# 画面設計書 19-Term Vectors

## 概要

本ドキュメントは、OpenSearchのTerm Vectors API（`_termvectors`）エンドポイントに関する画面設計書である。ドキュメントのフィールドにおけるterms（語彙）の情報と統計データを返すREST APIインターフェースを定義する。

### 本画面の処理概要

本APIは、特定のドキュメントまたは人工的に提供されたドキュメントに対して、各フィールドのterm vectors（用語ベクトル）情報を返す。term vectorsには、ドキュメント内の各用語の出現頻度、位置、オフセット、ペイロード等の情報が含まれる。

**業務上の目的・背景**：全文検索の精度向上やデバッグのために、ドキュメント内の各用語がどのようにインデックスされているかを確認する必要がある。Term Vectors APIにより、用語の出現頻度（TF）、ドキュメント頻度（DF）、位置情報等を取得でき、検索スコアリングの理解や、カスタムアナライザの動作確認に活用できる。また、類似ドキュメント検索（More Like This機能）の基礎データとしても使用される。

**画面へのアクセス方法**：HTTPクライアントから`GET /{index}/_termvectors/{id}`または`POST /{index}/_termvectors`エンドポイントにリクエストを送信する。

**主要な操作・処理内容**：
1. インデックス名とドキュメントIDからterm vectorsを取得する
2. IDを指定せずにリクエストボディで人工ドキュメントを提供し、term vectorsを計算する
3. 取得するフィールドの指定、統計情報の種類（term統計、フィールド統計）の制御
4. 位置情報、オフセット情報、ペイロード情報の取得制御

**画面遷移**：Multi Term Vectors（No.20）で複数ドキュメントのterm vectorsを一括取得できる。検索（No.21）のスコアリング理解に活用される。

**権限による表示制御**：対象インデックスに対するread権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 30 | TermVectors API | 主機能 | ドキュメントのフィールドにおけるterms情報と統計を返す主処理 |

## 画面種別

API（ドキュメント語彙分析）

## URL/ルーティング

| メソッド | パス | 説明 |
|---------|------|------|
| GET/POST | `/{index}/_termvectors/{id}` | 既存ドキュメントのterm vectorsを取得 |
| GET/POST | `/{index}/_termvectors` | 人工ドキュメントのterm vectorsを計算 |

## 入出力項目

### URLパスパラメータ

| パラメータ | 型 | 必須 | 説明 |
|-----------|------|------|------|
| index | string | はい | ドキュメントが格納されているインデックス名 |
| id | string | いいえ | ドキュメントID。未指定の場合はボディのdocパラメータで人工ドキュメントを提供 |

### クエリパラメータ

| パラメータ | 型 | 必須 | デフォルト | 説明 |
|-----------|------|------|-----------|------|
| term_statistics | boolean | いいえ | false | 総用語頻度とドキュメント頻度を返すかどうか |
| field_statistics | boolean | いいえ | true | ドキュメント数、ドキュメント頻度の合計、総用語頻度の合計を返すかどうか |
| fields | list | いいえ | - | 返すフィールドのカンマ区切りリスト |
| offsets | boolean | いいえ | true | 用語のオフセットを返すかどうか |
| positions | boolean | いいえ | true | 用語の位置を返すかどうか |
| payloads | boolean | いいえ | true | 用語のペイロードを返すかどうか |
| preference | string | いいえ | random | 操作を実行するノードまたはシャードの指定 |
| routing | string | いいえ | - | 特定のルーティング値 |
| realtime | boolean | いいえ | true | リアルタイムモードで操作を実行するかどうか |
| version | number | いいえ | - | 明示的なバージョン番号（同時実行制御） |
| version_type | enum | いいえ | - | バージョン種別（internal/external/external_gte/force） |

### リクエストボディ

| フィールド | 型 | 必須 | 説明 |
|-----------|------|------|------|
| doc | object | いいえ | 人工ドキュメント（ID未指定時にterm vectorsを計算するため） |
| per_field_analyzer | object | いいえ | フィールドごとのアナライザ指定 |
| fields | array | いいえ | 取得するフィールドのリスト |
| offsets | boolean | いいえ | オフセット取得制御 |
| positions | boolean | いいえ | 位置取得制御 |
| payloads | boolean | いいえ | ペイロード取得制御 |
| term_statistics | boolean | いいえ | 用語統計取得制御 |
| field_statistics | boolean | いいえ | フィールド統計取得制御 |
| filter | object | いいえ | 返す用語のフィルタリング条件 |

## 表示項目

### レスポンスボディ

| フィールド | 型 | 説明 |
|-----------|------|------|
| _index | string | インデックス名 |
| _id | string | ドキュメントID |
| _version | number | ドキュメントバージョン |
| found | boolean | ドキュメントが見つかったかどうか |
| took | number | 処理時間（ミリ秒） |
| term_vectors | object | フィールドごとのterm vector情報 |
| term_vectors.{field}.field_statistics | object | フィールド統計情報 |
| term_vectors.{field}.field_statistics.sum_doc_freq | number | ドキュメント頻度の合計 |
| term_vectors.{field}.field_statistics.doc_count | number | ドキュメント数 |
| term_vectors.{field}.field_statistics.sum_ttf | number | 総用語頻度の合計 |
| term_vectors.{field}.terms | object | 各用語の情報 |
| term_vectors.{field}.terms.{term}.term_freq | number | 用語の出現頻度 |
| term_vectors.{field}.terms.{term}.tokens | array | 用語の位置・オフセット情報 |

## イベント仕様

### 1-Term Vectorsリクエスト実行

1. `RestTermVectorsAction.prepareRequest()`がインデックス名とドキュメントIDを解析する（行82-92）
2. `TermVectorsRequest`オブジェクトを構築する（行83）
3. リクエストボディがある場合、`TermVectorsRequest.parseRequest()`でパースする（行84-88）
4. `readURIParameters()`でURLパラメータを設定する（行89）
5. `readURIParameters()`内で、fields, offsets, positions, payloads, routing, realtime, version, version_type, preference, term_statistics, field_statisticsを設定する（行94-108）
6. `NodeClient.termVectors()`を呼び出してterm vectorsを取得する（行91）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| Term Vectorsリクエスト | Luceneインデックス | SELECT | ドキュメントのterm vector情報を読み取る（更新なし） |

### テーブル別更新項目詳細

本APIは読み取り専用であり、データベース（Luceneインデックス）の更新は行わない。

## メッセージ仕様

| メッセージ種別 | 条件 | メッセージ内容 |
|--------------|------|--------------|
| 成功 | ドキュメント発見 | HTTPステータス200、found=true、term_vectors情報 |
| 成功 | ドキュメント未発見 | HTTPステータス200、found=false |
| 成功 | 人工ドキュメント | HTTPステータス200、計算されたterm_vectors情報 |

## 例外処理

| 例外 | 条件 | 動作 |
|------|------|------|
| IndexNotFoundException | 指定インデックスが存在しない場合 | HTTPステータス404 |
| RoutingMissingException | ルーティングが必須のインデックスでルーティング未指定 | HTTPステータス400 |

## 備考

- `term_statistics`はデフォルトfalseであり、有効にすると各用語のドキュメント頻度（df）と総用語頻度（ttf）が返される。パフォーマンスに影響するため、必要な場合のみ有効にすることが推奨される。
- `field_statistics`はデフォルトtrueであり、フィールド全体の統計情報が返される。
- 人工ドキュメント（doc指定）の場合、IDを指定せずにリクエストボディでドキュメントを提供し、既存のインデックスマッピングに基づいてterm vectorsを計算できる。
- `term_statistics`と`termStatistics`の両方のパラメータ名に対応している（行105-106）。これはキャメルケースとスネークケースの両方をサポートするための互換性措置。

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | termvectors.json | `rest-api-spec/src/main/resources/rest-api-spec/api/termvectors.json` | API定義。2つのURLパス、パラメータ定義 |
| 1-2 | TermVectorsRequest.java | `server/src/main/java/org/opensearch/action/termvectors/TermVectorsRequest.java` | リクエストデータ構造 |
| 1-3 | TermVectorsResponse.java | `server/src/main/java/org/opensearch/action/termvectors/TermVectorsResponse.java` | レスポンスデータ構造 |

**読解のコツ**: TermVectorsRequestのparseRequest()メソッドがボディパースの中心。selectedFields, flags（offsets/positions/payloads）等のフラグ管理に注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestTermVectorsAction.java | `server/src/main/java/org/opensearch/rest/action/document/RestTermVectorsAction.java` | RESTハンドラ |

**主要処理フロー**:
1. **行65-73**: routes()で4つのルートを定義（GET/POST x /{index}/_termvectors と /{index}/_termvectors/{id}）
2. **行82-92**: prepareRequest()でTermVectorsRequestの構築
3. **行83**: TermVectorsRequest(index, id)のコンストラクタ
4. **行84-88**: ボディがある場合のパース
5. **行89**: readURIParameters()の呼び出し
6. **行94-108**: readURIParameters()のstaticメソッド。fields, offsets, positions, payloads等の設定
7. **行105-108**: キャメルケースとスネークケースの両方のパラメータ名に対応

#### Step 3: fieldsパラメータの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | RestTermVectorsAction.java (addFieldStringsFromParameter) | `server/src/main/java/org/opensearch/rest/action/document/RestTermVectorsAction.java` | fieldsパラメータの処理（行111-128） |

**主要処理フロー**:
- **行111-128**: addFieldStringsFromParameter()でカンマ区切りのフィールド文字列をHashSetに変換

### プログラム呼び出し階層図

```
RestTermVectorsAction.prepareRequest()                  [行82]
    |
    +-- TermVectorsRequest(index, id)                   [行83]
    |
    +-- TermVectorsRequest.parseRequest()               [行86] (ボディあり時)
    |
    +-- readURIParameters()                             [行89]
    |       +-- addFieldStringsFromParameter()          [行96/111]
    |       +-- offsets/positions/payloads設定           [行97-99]
    |       +-- routing/realtime/version設定             [行100-103]
    |       +-- termStatistics/fieldStatistics設定       [行105-108]
    |
    +-- NodeClient.termVectors()                        [行91]
            |
            +-- TransportTermVectorsAction
                    +-- Luceneからterm vector情報取得
```

### データフロー図

```
[入力]                           [処理]                              [出力]

HTTPリクエスト              RestTermVectorsAction                TermVectorsResponse
(GET /{index}/          パラメータ解析・リクエスト構築
 _termvectors/{id})             |
   |                            v
   v                    TransportTermVectorsAction              レスポンスJSON
index + id              Luceneのterm vector読取                 {term_vectors:
(+ optional body)                                                {field: {terms:...}}}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| termvectors.json | `rest-api-spec/src/main/resources/rest-api-spec/api/termvectors.json` | API定義 | REST API仕様 |
| RestTermVectorsAction.java | `server/src/main/java/org/opensearch/rest/action/document/RestTermVectorsAction.java` | ソース | RESTハンドラ |
| TermVectorsRequest.java | `server/src/main/java/org/opensearch/action/termvectors/TermVectorsRequest.java` | ソース | リクエストデータ構造 |
| TermVectorsResponse.java | `server/src/main/java/org/opensearch/action/termvectors/TermVectorsResponse.java` | ソース | レスポンスデータ構造 |
| TransportTermVectorsAction.java | `server/src/main/java/org/opensearch/action/termvectors/TransportTermVectorsAction.java` | ソース | Transport層の実行処理 |
